/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: PlatformLayerWin32.h                                                  *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              22/06/2007       1.0                              *
*******************************************************************************/

#ifndef _PLATFORMLAYERWIN32_H_
#define _PLATFORMLAYERWIN32_H_

using namespace std;
#include <map>
#include "PlatformLayer.h"

const int BUFFER_SIZE = 2048;

typedef struct _itemDsc{
    char rhubname[BUFFER_SIZE];
    int port;
    int qtyep;
    char stdDeviceDsc[BUFFER_SIZE];
    char strManufacturer[255];
    char strProduct[255];
    char strSerialNumber[255];
    char stdConfigurationDsc[9];
    char stdInterfaceDsc[9];
    char stdEndpointDsc[15][7];
} itemDsc;

class platformLayerWin32 : public platformLayer {

    private:
        map<int,itemDsc> descriptors;
        void findDevices(void);
        void findEndpoints(int,itemDsc&);
    public:
        platformLayerWin32();
        ~platformLayerWin32();
        map<int,itemDsc> getDescriptors();
};

#endif
